/*-----------------------------------------------------------------------------
 * EcError.h                
 * Copyright                acontis technologies GmbH, Weingarten, Germany
 * Response                 Stefan Zintgraf
 * Description              EtherCAT Master error definitions
 *---------------------------------------------------------------------------*/


#ifndef INC_ECERROR
#define INC_ECERROR

/*-DEFINES-------------------------------------------------------------------*/



/*********************************************************************

  Do not change these offset!
  Insert new codes in the free areas

   Errorcode                     Text-ID
    Start   |      End    | Start   | End    | Size  |  Description
-----------------------------------------------------------------------
0x9811.0000 | 0x9811.013F | 0x0000  | 0x013F | 0x140 | Master Error Code
            |             |         |        |       |
0x9811.0140 | 0x9811.01BF | 0x0140  | 0x01BF | 0x040 | free area 2
            |             |         |        |       |
0x9811.0180 | 0x9811.01BF | 0x0180  | 0x01BF | 0x040 | RAS
            |             |         |        |       |
0x9812.01C0 | 0x9812.01FF | 0x01C0  | 0x01FF | 0x040 | DCM
            |             |         |        |       |
    -       |      -      | 0x0200  | 0x02FF | 0x100 | Application framework
            |             |         |        |       |
    -       |      -      | 0x0300  | 0x03FF | 0x100 | AL Status Codes
            |             |         |        |       |


*********************************************************************/


#define       EC_E_NOERROR                      ((EC_T_DWORD)0x00000000)
#define EC_SZTXT_E_NOERROR                      "No Error"

#define       EC_E_ERROR                        ((EC_T_DWORD)0x98110000)
#define EC_SZTXT_E_ERROR                        "Unspecific Error"
#define       EC_E_ERROR_LAST                   ((EC_T_DWORD)0x9811013F)

#define       EMRAS_E_ERROR                     ((EC_T_DWORD)0x98110180)
#define EMRAS_SZTXT_E_ERROR                     "Unspecific RAS Error"
#define       EMRAS_E_ERROR_LAST                ((EC_T_DWORD)0x981101BF)

#define       DCM_E_ERROR                       ((EC_T_DWORD)0x981201C0)
#define DCM_SZTXT_E_ERROR                       "Unspecific DCM Error"
#define       DCM_E_ERROR_LAST                  ((EC_T_DWORD)0x981201FF)

#define       EC_TEXTBASE                       ((EC_T_WORD)0x0200)
#define EC_SZTXT_TEXTBASE                       "Unknown Text (Base)"
#define       EC_TEXTBASE_LAST                  ((EC_T_WORD)0x02FF)

#define       EC_ALSTATEBASE                    ((EC_T_WORD)0x0300)
#define EC_SZTXT_ALSTATEBASE                    "AL Status No Error"
#define       EC_ALSTATEBASE_LAST               ((EC_T_WORD)0x03FF)


/*********************************************************************/
/* Master Error Strings                                              */
/*********************************************************************/

#define       EC_E_NOTSUPPORTED                 ((EC_T_DWORD)EC_E_ERROR+0x01)
#define EC_SZTXT_E_NOTSUPPORTED                 "ERROR: feature not supported"

#define       EC_E_INVALIDINDEX                 ((EC_T_DWORD)EC_E_ERROR+0x02)
#define EC_SZTXT_E_INVALIDINDEX                 "ERROR: invalid index"

#define       EC_E_INVALIDOFFSET                ((EC_T_DWORD)EC_E_ERROR+0x03)
#define EC_SZTXT_E_INVALIDOFFSET                "ERROR: invalid offset"


#define       EC_E_INVALIDSIZE                  ((EC_T_DWORD)EC_E_ERROR+0x05)
#define EC_SZTXT_E_INVALIDSIZE                  "ERROR: invalid size"

#define       EC_E_INVALIDDATA                  ((EC_T_DWORD)EC_E_ERROR+0x06)
#define EC_SZTXT_E_INVALIDDATA                  "ERROR: invalid data"

#define       EC_E_NOTREADY                     ((EC_T_DWORD)EC_E_ERROR+0x07)
#define EC_SZTXT_E_NOTREADY                     "ERROR: not ready"

#define       EC_E_BUSY                         ((EC_T_DWORD)EC_E_ERROR+0x08)
#define EC_SZTXT_E_BUSY                         "ERROR: busy"

#define       EC_E_ACYC_FRM_FREEQ_EMPTY         ((EC_T_DWORD)EC_E_ERROR+0x09)
#define EC_SZTXT_E_ACYC_FRM_FREEQ_EMPTY         "ERROR: cannot queue acyclic EtherCAT command (MasterConfig.dwMaxQueuedEthFrames)"

#define       EC_E_NOMEMORY                     ((EC_T_DWORD)EC_E_ERROR+0x0A)
#define EC_SZTXT_E_NOMEMORY                     "ERROR: no memory left"

#define       EC_E_INVALIDPARM                  ((EC_T_DWORD)EC_E_ERROR+0x0B)
#define EC_SZTXT_E_INVALIDPARM                  "ERROR: invalid parameter"

#define       EC_E_NOTFOUND                     ((EC_T_DWORD)EC_E_ERROR+0x0C)
#define EC_SZTXT_E_NOTFOUND                     "ERROR: not found"

#define       EC_E_INVALIDSTATE                 ((EC_T_DWORD)EC_E_ERROR+0x0E)
#define EC_SZTXT_E_INVALIDSTATE                 "ERROR: invalid state"

#define       EC_E_TIMER_LIST_FULL              ((EC_T_DWORD)EC_E_ERROR+0x0F)
#define EC_SZTXT_E_TIMER_LIST_FULL              "ERROR: cannot add slave to timer list"

#define       EC_E_TIMEOUT                      ((EC_T_DWORD)EC_E_ERROR+0x10)
#define EC_SZTXT_E_TIMEOUT                      "ERROR: Time-out"

#define       EC_E_OPENFAILED                   ((EC_T_DWORD)EC_E_ERROR+0x11)
#define EC_SZTXT_E_OPENFAILED                   "ERROR: open failed"

#define       EC_E_SENDFAILED                   ((EC_T_DWORD)EC_E_ERROR+0x12)
#define EC_SZTXT_E_SENDFAILED                   "ERROR: send failed"

#define       EC_E_INSERTMAILBOX                ((EC_T_DWORD)EC_E_ERROR+0x13)
#define EC_SZTXT_E_INSERTMAILBOX                "ERROR: insert mailbox error"

#define       EC_E_INVALIDCMD                   ((EC_T_DWORD)EC_E_ERROR+0x14)
#define EC_SZTXT_E_INVALIDCMD                   "ERROR: invalid mailbox command"

#define       EC_E_UNKNOWN_MBX_PROTOCOL         ((EC_T_DWORD)EC_E_ERROR+0x15)
#define EC_SZTXT_E_UNKNOWN_MBX_PROTOCOL         "ERROR: unknown mailbox protocol command"

#define       EC_E_ACCESSDENIED                 ((EC_T_DWORD)EC_E_ERROR+0x16)
#define EC_SZTXT_E_ACCESSDENIED                 "ERROR: access denied"

#define       EC_E_PRODKEY_INVALID              ((EC_T_DWORD)EC_E_ERROR+0x1A)
#define EC_SZTXT_E_PRODKEY_INVALID              "ERROR: invalid product key"

#define       EC_E_WRONG_FORMAT                 ((EC_T_DWORD)EC_E_ERROR+0x1B)
#define EC_SZTXT_E_WRONG_FORMAT                 "ERROR: wrong format of master XML file"

#define       EC_E_FEATURE_DISABLED             ((EC_T_DWORD)EC_E_ERROR+0x1C)
#define EC_SZTXT_E_FEATURE_DISABLED             "ERROR: feature disabled"

#define       EC_E_SHADOW_MEMORY                ((EC_T_DWORD)EC_E_ERROR+0x1D)
#define EC_SZTXT_E_SHADOW_MEMORY                "ERROR: shadow memory requested in wrong mode"

#define       EC_E_BUSCONFIG_MISMATCH           ((EC_T_DWORD)EC_E_ERROR+0x1E)
#define EC_SZTXT_E_BUSCONFIG_MISMATCH           "Bus configuration mismatch"

#define       EC_E_CONFIGDATAREAD               ((EC_T_DWORD)EC_E_ERROR+0x1F)
#define EC_SZTXT_E_CONFIGDATAREAD               "ERROR: Error in reading config file"

#define       EC_E_XML_CYCCMDS_MISSING          ((EC_T_DWORD)EC_E_ERROR+0x21)
#define EC_SZTXT_E_XML_CYCCMDS_MISSING          "ERROR: Cyclic commands are missing"

#define       EC_E_XML_ALSTATUS_READ_MISSING    ((EC_T_DWORD)EC_E_ERROR+0x22)
#define EC_SZTXT_E_XML_ALSTATUS_READ_MISSING    "ERROR: AL_STATUS register read missing in XML file for at least one state"

#define       EC_E_MCSM_FATAL_ERROR             ((EC_T_DWORD)EC_E_ERROR+0x23)
#define EC_SZTXT_E_MCSM_FATAL_ERROR             "ERROR: Fatal internal McSm"

#define       EC_E_SLAVE_ERROR                  ((EC_T_DWORD)EC_E_ERROR+0x24)
#define EC_SZTXT_E_SLAVE_ERROR                  "ERROR: Slave error"

#define       EC_E_FRAME_LOST                   ((EC_T_DWORD)EC_E_ERROR+0x25)
#define EC_SZTXT_E_FRAME_LOST                   "ERROR: Frame lost, IDX mismatch"

#define       EC_E_CMD_MISSING                  ((EC_T_DWORD)EC_E_ERROR+0x26)
#define EC_SZTXT_E_CMD_MISSING                  "ERROR: At least one EtherCAT command is missing in the received frame"

#define       EC_E_INVALID_DCL_MODE             ((EC_T_DWORD)EC_E_ERROR+0x28)
#define EC_SZTXT_E_INVALID_DCL_MODE             "ERROR: IOCTL EC_IOCTL_DC_LATCH_REQ_LTIMVALS not possible in DC Latching auto read mode"

#define       EC_E_AI_ADDRESS                   ((EC_T_DWORD)EC_E_ERROR+0x29)
#define EC_SZTXT_E_AI_ADDRESS                   "ERROR: Auto increment address - increment mismatch (slave missing)"

#define       EC_E_INVALID_SLAVE_STATE          ((EC_T_DWORD)EC_E_ERROR+0x2A)
#define EC_SZTXT_E_INVALID_SLAVE_STATE          "ERROR: Slave in invalid state, e.g. not in OP (API not callable in this state)"

#define       EC_E_SLAVE_NOT_ADDRESSABLE        ((EC_T_DWORD)EC_E_ERROR+0x2B)
#define EC_SZTXT_E_SLAVE_NOT_ADDRESSABLE        "ERROR: Fixed station address lost or slave missing - FPRD to AL_STATUS failed"

#define       EC_E_CYC_CMDS_OVERFLOW            ((EC_T_DWORD)EC_E_ERROR+0x2C)
#define EC_SZTXT_E_CYC_CMDS_OVERFLOW            "ERROR: Too many cyclic commands in XML configuration file. (Check EC_T_MASTER_CONFIG.dwMaxQueuedEthFrames)"

#define       EC_E_LINK_DISCONNECTED            ((EC_T_DWORD)EC_E_ERROR+0x2D)
#define EC_SZTXT_E_LINK_DISCONNECTED            "ERROR: Ethernet link cable disconnected"

#define       EC_E_MASTERCORE_INACCESSIBLE      ((EC_T_DWORD)EC_E_ERROR+0x2E)
#define EC_SZTXT_E_MASTERCORE_INACCESSIBLE      "ERROR: Master core not accessible"

#define       EC_E_COE_MBXSND_WKC_ERROR         ((EC_T_DWORD)EC_E_ERROR+0x2F)
#define EC_SZTXT_E_COE_MBXSND_WKC_ERROR         "ERROR: COE mailbox send: working counter"

#define       EC_E_COE_MBXRCV_WKC_ERROR         ((EC_T_DWORD)EC_E_ERROR+0x30)
#define EC_SZTXT_E_COE_MBXRCV_WKC_ERROR         "ERROR: COE mailbox receive: working counter"

#define       EC_E_NO_MBX_SUPPORT               ((EC_T_DWORD)EC_E_ERROR+0x31)
#define EC_SZTXT_E_NO_MBX_SUPPORT               "ERROR: No mailbox support"

#define       EC_E_NO_COE_SUPPORT               ((EC_T_DWORD)EC_E_ERROR+0x32)
#define EC_SZTXT_E_NO_COE_SUPPORT               "ERROR: CoE protocol not supported"

#define       EC_E_NO_EOE_SUPPORT               ((EC_T_DWORD)EC_E_ERROR+0x33)
#define EC_SZTXT_E_NO_EOE_SUPPORT               "ERROR: EoE protocol not supported"

#define       EC_E_NO_FOE_SUPPORT               ((EC_T_DWORD)EC_E_ERROR+0x34)
#define EC_SZTXT_E_NO_FOE_SUPPORT               "ERROR: FoE protocol not supported"

#define       EC_E_NO_SOE_SUPPORT               ((EC_T_DWORD)EC_E_ERROR+0x35)
#define EC_SZTXT_E_NO_SOE_SUPPORT               "ERROR: SoE protocol not supported"

#define       EC_E_NO_VOE_SUPPORT               ((EC_T_DWORD)EC_E_ERROR+0x36)
#define EC_SZTXT_E_NO_VOE_SUPPORT               "ERROR: VoE protocol not supported"

#define       EC_E_EVAL_VIOLATION               ((EC_T_DWORD)EC_E_ERROR+0x37)
#define EC_SZTXT_E_EVAL_VIOLATION               "ERROR: Configuration violates evaluation limits"

#define       EC_E_EVAL_EXPIRED                 ((EC_T_DWORD)EC_E_ERROR+0x38)
#define EC_SZTXT_E_EVAL_EXPIRED                 "ERROR: Evaluation time limit reached"
          
#define       EC_E_SDO_ABORTCODE_TOGGLE         ((EC_T_DWORD)EC_E_ERROR+0x40)
#define EC_SZTXT_E_SDO_ABORTCODE_TOGGLE         "ERROR SDO: Toggle bit not alternated."

#define       EC_E_SDO_ABORTCODE_TIMEOUT        ((EC_T_DWORD)EC_E_ERROR+0x41)
#define EC_SZTXT_E_SDO_ABORTCODE_TIMEOUT        "ERROR SDO: SDO protocol time-out."

#define       EC_E_SDO_ABORTCODE_CCS_SCS        ((EC_T_DWORD)EC_E_ERROR+0x42)
#define EC_SZTXT_E_SDO_ABORTCODE_CCS_SCS        "ERROR SDO: Client/server command specifier not valid or unknown."

#define       EC_E_SDO_ABORTCODE_BLK_SIZE       ((EC_T_DWORD)EC_E_ERROR+0x43)
#define EC_SZTXT_E_SDO_ABORTCODE_BLK_SIZE       "ERROR SDO: Invalid block size (block mode only)."

#define       EC_E_SDO_ABORTCODE_SEQNO          ((EC_T_DWORD)EC_E_ERROR+0x44)
#define EC_SZTXT_E_SDO_ABORTCODE_SEQNO          "ERROR SDO: Invalid sequence number (block mode only)."

#define       EC_E_SDO_ABORTCODE_CRC            ((EC_T_DWORD)EC_E_ERROR+0x45)
#define EC_SZTXT_E_SDO_ABORTCODE_CRC            "ERROR SDO: CRC error (block mode only)."

#define       EC_E_SDO_ABORTCODE_MEMORY         ((EC_T_DWORD)EC_E_ERROR+0x46)
#define EC_SZTXT_E_SDO_ABORTCODE_MEMORY         "ERROR SDO: Out of memory."

#define       EC_E_SDO_ABORTCODE_ACCESS         ((EC_T_DWORD)EC_E_ERROR+0x47)
#define EC_SZTXT_E_SDO_ABORTCODE_ACCESS         "ERROR SDO: Unsupported access to an object."

#define       EC_E_SDO_ABORTCODE_WRITEONLY      ((EC_T_DWORD)EC_E_ERROR+0x48)
#define EC_SZTXT_E_SDO_ABORTCODE_WRITEONLY      "ERROR SDO: Attempt to read a write only object."

#define       EC_E_SDO_ABORTCODE_READONLY       ((EC_T_DWORD)EC_E_ERROR+0x49)
#define EC_SZTXT_E_SDO_ABORTCODE_READONLY       "ERROR SDO: Attempt to write a read only object."

#define       EC_E_SDO_ABORTCODE_INDEX          ((EC_T_DWORD)EC_E_ERROR+0x4A)
#define EC_SZTXT_E_SDO_ABORTCODE_INDEX          "ERROR SDO: Object does not exist in the object dictionary."

#define       EC_E_SDO_ABORTCODE_PDO_MAP        ((EC_T_DWORD)EC_E_ERROR+0x4B)
#define EC_SZTXT_E_SDO_ABORTCODE_PDO_MAP        "ERROR SDO: Object cannot be mapped to the PDO."

#define       EC_E_SDO_ABORTCODE_PDO_LEN        ((EC_T_DWORD)EC_E_ERROR+0x4C)
#define EC_SZTXT_E_SDO_ABORTCODE_PDO_LEN        "ERROR SDO: Number and length of objects to be mapped exceed PDO length"

#define       EC_E_SDO_ABORTCODE_P_INCOMP       ((EC_T_DWORD)EC_E_ERROR+0x4D)
#define EC_SZTXT_E_SDO_ABORTCODE_P_INCOMP       "ERROR SDO: General parameter incompatibility"

#define       EC_E_SDO_ABORTCODE_I_INCOMP       ((EC_T_DWORD)EC_E_ERROR+0x4E)
#define EC_SZTXT_E_SDO_ABORTCODE_I_INCOMP       "ERROR SDO: General internal incompatibility in the device."

#define       EC_E_SDO_ABORTCODE_HARDWARE       ((EC_T_DWORD)EC_E_ERROR+0x4F)
#define EC_SZTXT_E_SDO_ABORTCODE_HARDWARE       "ERROR SDO: Access failed due to an hardware error."

#define       EC_E_SDO_ABORTCODE_DATA_SIZE      ((EC_T_DWORD)EC_E_ERROR+0x50)
#define EC_SZTXT_E_SDO_ABORTCODE_DATA_SIZE      "ERROR SDO: Data type does not match, length of service parameter does not match"

#define       EC_E_SDO_ABORTCODE_DATA_SIZE1     ((EC_T_DWORD)EC_E_ERROR+0x51)
#define EC_SZTXT_E_SDO_ABORTCODE_DATA_SIZE1     "ERROR SDO: Data type does not match, service parameter too long"

#define       EC_E_SDO_ABORTCODE_DATA_SIZE2     ((EC_T_DWORD)EC_E_ERROR+0x52)
#define EC_SZTXT_E_SDO_ABORTCODE_DATA_SIZE2     "ERROR SDO: Data type does not match, service parameter too short"

#define       EC_E_SDO_ABORTCODE_OFFSET         ((EC_T_DWORD)EC_E_ERROR+0x53)
#define EC_SZTXT_E_SDO_ABORTCODE_OFFSET         "ERROR SDO: Sub-index does not exist."

#define       EC_E_SDO_ABORTCODE_DATA_RANGE     ((EC_T_DWORD)EC_E_ERROR+0x54)
#define EC_SZTXT_E_SDO_ABORTCODE_DATA_RANGE     "ERROR SDO: Write access - Parameter value out of range"

#define       EC_E_SDO_ABORTCODE_DATA_RANGE1    ((EC_T_DWORD)EC_E_ERROR+0x55)
#define EC_SZTXT_E_SDO_ABORTCODE_DATA_RANGE1    "ERROR SDO: Write access - Parameter value out of high limit"

#define       EC_E_SDO_ABORTCODE_DATA_RANGE2    ((EC_T_DWORD)EC_E_ERROR+0x56)
#define EC_SZTXT_E_SDO_ABORTCODE_DATA_RANGE2    "ERROR SDO: Write access - Parameter value out of low limit"

#define       EC_E_SDO_ABORTCODE_MINMAX         ((EC_T_DWORD)EC_E_ERROR+0x57)
#define EC_SZTXT_E_SDO_ABORTCODE_MINMAX         "ERROR SDO: Maximum value is less than minimum value."

#define       EC_E_SDO_ABORTCODE_GENERAL        ((EC_T_DWORD)EC_E_ERROR+0x58)
#define EC_SZTXT_E_SDO_ABORTCODE_GENERAL        "ERROR SDO: General error"

#define       EC_E_SDO_ABORTCODE_TRANSFER       ((EC_T_DWORD)EC_E_ERROR+0x59)
#define EC_SZTXT_E_SDO_ABORTCODE_TRANSFER       "ERROR SDO: Unable to transfer or store data to the application"

#define       EC_E_SDO_ABORTCODE_TRANSFER1      ((EC_T_DWORD)EC_E_ERROR+0x5A)
#define EC_SZTXT_E_SDO_ABORTCODE_TRANSFER1      "ERROR SDO: Unable to transfer or store data to the application because of local control"

#define       EC_E_SDO_ABORTCODE_TRANSFER2      ((EC_T_DWORD)EC_E_ERROR+0x5B)
#define EC_SZTXT_E_SDO_ABORTCODE_TRANSFER2      "ERROR SDO: Unable to transfer or store data to the application because of the present device state"

#define       EC_E_SDO_ABORTCODE_DICTIONARY     ((EC_T_DWORD)EC_E_ERROR+0x5C)
#define EC_SZTXT_E_SDO_ABORTCODE_DICTIONARY     "ERROR SDO: Dynamic generation of object dictionary failed or missing object dictionary (e.g. object dictionary is generated from file and generation fails because of an file error)."
        
#define       EC_E_SDO_ABORTCODE_UNKNOWN        ((EC_T_DWORD)EC_E_ERROR+0x5D)
#define EC_SZTXT_E_SDO_ABORTCODE_UNKNOWN        "ERROR SDO: Unknown code."

                                                                        
#define       EC_E_FOE_ERRCODE_NOTDEFINED       ((EC_T_DWORD)EC_E_ERROR+0x60)
#define EC_SZTXT_E_FOE_ERRCODE_NOTDEFINED       "FoE error - Vendor specific FoE error"

#define       EC_E_FOE_ERRCODE_NOTFOUND         ((EC_T_DWORD)EC_E_ERROR+0x61)
#define EC_SZTXT_E_FOE_ERRCODE_NOTFOUND         "FoE error - not found"

#define       EC_E_FOE_ERRCODE_ACCESS           ((EC_T_DWORD)EC_E_ERROR+0x62)
#define EC_SZTXT_E_FOE_ERRCODE_ACCESS           "FoE error - access denied"

#define       EC_E_FOE_ERRCODE_DISKFULL         ((EC_T_DWORD)EC_E_ERROR+0x63)
#define EC_SZTXT_E_FOE_ERRCODE_DISKFULL         "FoE error - disk full"

#define       EC_E_FOE_ERRCODE_ILLEGAL         ((EC_T_DWORD)EC_E_ERROR+0x64)
#define EC_SZTXT_E_FOE_ERRCODE_ILLEGAL         "FoE error - illegal"

#define       EC_E_FOE_ERRCODE_PACKENO          ((EC_T_DWORD)EC_E_ERROR+0x65)
#define EC_SZTXT_E_FOE_ERRCODE_PACKENO          "FoE error - wrong packet number"

#define       EC_E_FOE_ERRCODE_EXISTS           ((EC_T_DWORD)EC_E_ERROR+0x66)
#define EC_SZTXT_E_FOE_ERRCODE_EXISTS           "FoE error - already exists"

#define       EC_E_FOE_ERRCODE_NOUSER           ((EC_T_DWORD)EC_E_ERROR+0x67)
#define EC_SZTXT_E_FOE_ERRCODE_NOUSER           "FoE error - user missing"

#define       EC_E_FOE_ERRCODE_BOOTSTRAPONLY    ((EC_T_DWORD)EC_E_ERROR+0x68)
#define EC_SZTXT_E_FOE_ERRCODE_BOOTSTRAPONLY    "FoE error - bootstrap only"

#define       EC_E_FOE_ERRCODE_NOTINBOOTSTRAP   ((EC_T_DWORD)EC_E_ERROR+0x69)
#define EC_SZTXT_E_FOE_ERRCODE_NOTINBOOTSTRAP   "FoE error - not bootstrap"

#define       EC_E_FOE_ERRCODE_INVALIDPASSWORD  ((EC_T_DWORD)EC_E_ERROR+0x6A)
#define EC_SZTXT_E_FOE_ERRCODE_INVALIDPASSWORD  "FoE error - no rights"

#define       EC_E_FOE_ERRCODE_PROGERROR        ((EC_T_DWORD)EC_E_ERROR+0x6B)
#define EC_SZTXT_E_FOE_ERRCODE_PROGERROR        "FoE - program error"

#define       EC_E_CFGFILENOTFOUND              ((EC_T_DWORD)EC_E_ERROR+0x70)
#define EC_SZTXT_E_CFGFILENOTFOUND              "ERROR: master configuration not found"

#define       EC_E_EEPROMREADERROR              ((EC_T_DWORD)EC_E_ERROR+0x71)
#define EC_SZTXT_E_EEPROMREADERROR              "ERROR: command error while EEPROM upload"

#define       EC_E_EEPROMWRITEERROR             ((EC_T_DWORD)EC_E_ERROR+0x72)
#define EC_SZTXT_E_EEPROMWRITEERROR             "ERROR: command error while EEPROM download"

#define       EC_E_XML_CYCCMDS_SIZEMISMATCH     ((EC_T_DWORD)EC_E_ERROR+0x73)
#define EC_SZTXT_E_XML_CYCCMDS_SIZEMISMATCH     "ERROR: Cyclic command wrong size (too long)"

#define       EC_E_XML_INVALID_INP_OFF          ((EC_T_DWORD)EC_E_ERROR+0x74)
#define EC_SZTXT_E_XML_INVALID_INP_OFF          "ERROR: Invalid input offset in cyc cmd, please check InputOffs"

#define       EC_E_XML_INVALID_OUT_OFF          ((EC_T_DWORD)EC_E_ERROR+0x75)
#define EC_SZTXT_E_XML_INVALID_OUT_OFF          "ERROR: Invalid output offset in cyc cmd, please check OutputOffs"

#define       EC_E_PORTCLOSE                    ((EC_T_DWORD)EC_E_ERROR+0x76)
#define EC_SZTXT_E_PORTCLOSE                    "ERROR: Port Close failed"

#define       EC_E_PORTOPEN                     ((EC_T_DWORD)EC_E_ERROR+0x77)
#define EC_SZTXT_E_PORTOPEN                     "ERROR: Port Open failed"


#define       EC_E_SOE_ERRORCODE_INVALID_ACCESS ((EC_T_DWORD)EC_E_ERROR+0x78)
#define EC_SZTXT_E_SOE_ERRORCODE_INVALID_ACCESS "SoE error - invalid access to element 0" 

#define       EC_E_SOE_ERRORCODE_NOT_EXIST      ((EC_T_DWORD)EC_E_ERROR+0x79)
#define EC_SZTXT_E_SOE_ERRORCODE_NOT_EXIST      "SoE error - does not exist"
 
#define       EC_E_SOE_ERRORCODE_INVL_ACC_ELEM1 ((EC_T_DWORD)EC_E_ERROR+0x7a)
#define EC_SZTXT_E_SOE_ERRORCODE_INVL_ACC_ELEM1 "SoE error - invalid access to element 1" 

#define       EC_E_SOE_ERRORCODE_NAME_NOT_EXIST ((EC_T_DWORD)EC_E_ERROR+0x7b)
#define EC_SZTXT_E_SOE_ERRORCODE_NAME_NOT_EXIST "SoE error - name does not exist" 

#define       EC_E_SOE_ERRORCODE_NAME_UNDERSIZE ((EC_T_DWORD)EC_E_ERROR+0x7c)
#define EC_SZTXT_E_SOE_ERRORCODE_NAME_UNDERSIZE "SoE error - name undersize in transmission" 

#define       EC_E_SOE_ERRORCODE_NAME_OVERSIZE  ((EC_T_DWORD)EC_E_ERROR+0x7d)
#define EC_SZTXT_E_SOE_ERRORCODE_NAME_OVERSIZE  "SoE error - name oversize in transmission" 

#define       EC_E_SOE_ERRORCODE_NAME_UNCHANGE  ((EC_T_DWORD)EC_E_ERROR+0x7e)
#define EC_SZTXT_E_SOE_ERRORCODE_NAME_UNCHANGE  "SoE error - name unchangeable" 

#define       EC_E_SOE_ERRORCODE_NAME_WR_PROT   ((EC_T_DWORD)EC_E_ERROR+0x7f)
#define EC_SZTXT_E_SOE_ERRORCODE_NAME_WR_PROT   "SoE error - name currently write-protected" 

#define       EC_E_SOE_ERRORCODE_UNDERS_TRANS   ((EC_T_DWORD)EC_E_ERROR+0x80)
#define EC_SZTXT_E_SOE_ERRORCODE_UNDERS_TRANS   "SoE error - attribute undersize in transmission"
              
#define       EC_E_SOE_ERRORCODE_OVERS_TRANS    ((EC_T_DWORD)EC_E_ERROR+0x81)
#define EC_SZTXT_E_SOE_ERRORCODE_OVERS_TRANS    "SoE error - attribute oversize in transmission" 

#define       EC_E_SOE_ERRORCODE_ATTR_UNCHANGE  ((EC_T_DWORD)EC_E_ERROR+0x82)
#define EC_SZTXT_E_SOE_ERRORCODE_ATTR_UNCHANGE  "SoE error - attribute unchangeable" 

#define       EC_E_SOE_ERRORCODE_ATTR_WR_PROT   ((EC_T_DWORD)EC_E_ERROR+0x83)
#define EC_SZTXT_E_SOE_ERRORCODE_ATTR_WR_PROT   "SoE error - attribute currently write-protected" 

#define       EC_E_SOE_ERRORCODE_UNIT_NOT_EXIST ((EC_T_DWORD)EC_E_ERROR+0x84)
#define EC_SZTXT_E_SOE_ERRORCODE_UNIT_NOT_EXIST "SoE error - unit does not exist" 

#define       EC_E_SOE_ERRORCODE_UNIT_UNDERSIZE ((EC_T_DWORD)EC_E_ERROR+0x85)
#define EC_SZTXT_E_SOE_ERRORCODE_UNIT_UNDERSIZE "SoE error - unit undersize in transmission" 

#define       EC_E_SOE_ERRORCODE_UNIT_OVERSIZE  ((EC_T_DWORD)EC_E_ERROR+0x86)
#define EC_SZTXT_E_SOE_ERRORCODE_UNIT_OVERSIZE  "SoE error - unit oversize in transmission" 

#define       EC_E_SOE_ERRORCODE_UNIT_UNCHANGE  ((EC_T_DWORD)EC_E_ERROR+0x87)
#define EC_SZTXT_E_SOE_ERRORCODE_UNIT_UNCHANGE  "SoE error - unit unchangeable" 

#define       EC_E_SOE_ERRORCODE_UNIT_WR_PROT   ((EC_T_DWORD)EC_E_ERROR+0x88)
#define EC_SZTXT_E_SOE_ERRORCODE_UNIT_WR_PROT   "SoE error - unit currently write-protected" 

#define       EC_E_SOE_ERRORCODE_MIN_NOT_EXIST  ((EC_T_DWORD)EC_E_ERROR+0x89)
#define EC_SZTXT_E_SOE_ERRORCODE_MIN_NOT_EXIST  "SoE error - minimum input value does not exist" 

#define       EC_E_SOE_ERRORCODE_MIN_UNDERSIZE  ((EC_T_DWORD)EC_E_ERROR+0x8a)
#define EC_SZTXT_E_SOE_ERRORCODE_MIN_UNDERSIZE  "SoE error - minimum input value undersize in transmission" 

#define       EC_E_SOE_ERRORCODE_MIN_OVERSIZE   ((EC_T_DWORD)EC_E_ERROR+0x8b)
#define EC_SZTXT_E_SOE_ERRORCODE_MIN_OVERSIZE   "SoE error - minimum input value oversize in transmission" 

#define       EC_E_SOE_ERRORCODE_MIN_UNCHANGE   ((EC_T_DWORD)EC_E_ERROR+0x8c)
#define EC_SZTXT_E_SOE_ERRORCODE_MIN_UNCHANGE   "SoE error - minimum input value unchangeable" 

#define       EC_E_SOE_ERRORCODE_MIN_WR_PROT    ((EC_T_DWORD)EC_E_ERROR+0x8d)
#define EC_SZTXT_E_SOE_ERRORCODE_MIN_WR_PROT    "SoE error - minimum input value currently write-protected" 

#define       EC_E_SOE_ERRORCODE_MAX_NOT_EXIST  ((EC_T_DWORD)EC_E_ERROR+0x8e)
#define EC_SZTXT_E_SOE_ERRORCODE_MAX_NOT_EXIST  "SoE error - maximum input value does not exist" 

#define       EC_E_SOE_ERRORCODE_MAX_UNDERSIZE  ((EC_T_DWORD)EC_E_ERROR+0x8f)
#define EC_SZTXT_E_SOE_ERRORCODE_MAX_UNDERSIZE  "SoE error - maximum input value undersize in transmission" 

#define       EC_E_SOE_ERRORCODE_MAX_OVERSIZE   ((EC_T_DWORD)EC_E_ERROR+0x90)
#define EC_SZTXT_E_SOE_ERRORCODE_MAX_OVERSIZE   "SoE error - maximum input value oversize in transmission" 

#define       EC_E_SOE_ERRORCODE_MAX_UNCHANGE   ((EC_T_DWORD)EC_E_ERROR+0x91)
#define EC_SZTXT_E_SOE_ERRORCODE_MAX_UNCHANGE   "SoE error - maximum input value unchangeable" 

#define       EC_E_SOE_ERRORCODE_MAX_WR_PROT    ((EC_T_DWORD)EC_E_ERROR+0x92)
#define EC_SZTXT_E_SOE_ERRORCODE_MAX_WR_PROT    "SoE error - maximum input value currently write-protected" 

#define       EC_E_SOE_ERRORCODE_DATA_NOT_EXIST ((EC_T_DWORD)EC_E_ERROR+0x93)
#define EC_SZTXT_E_SOE_ERRORCODE_DATA_NOT_EXIST "SoE error - data item does not exist" 

#define       EC_E_SOE_ERRORCODE_DATA_UNDERSIZE ((EC_T_DWORD)EC_E_ERROR+0x94)
#define EC_SZTXT_E_SOE_ERRORCODE_DATA_UNDERSIZE "SoE error - data item undersize in transmission" 

#define       EC_E_SOE_ERRORCODE_DATA_OVERSIZE  ((EC_T_DWORD)EC_E_ERROR+0x95)
#define EC_SZTXT_E_SOE_ERRORCODE_DATA_OVERSIZE  "SoE error - data item oversize in transmission" 

#define       EC_E_SOE_ERRORCODE_DATA_UNCHANGE  ((EC_T_DWORD)EC_E_ERROR+0x96)
#define EC_SZTXT_E_SOE_ERRORCODE_DATA_UNCHANGE  "SoE error - data item unchangeable" 

#define       EC_E_SOE_ERRORCODE_DATA_WR_PROT   ((EC_T_DWORD)EC_E_ERROR+0x97)
#define EC_SZTXT_E_SOE_ERRORCODE_DATA_WR_PROT   "SoE error - data item currently write-protected" 

#define       EC_E_SOE_ERRORCODE_DATA_MIN_LIMIT ((EC_T_DWORD)EC_E_ERROR+0x98)
#define EC_SZTXT_E_SOE_ERRORCODE_DATA_MIN_LIMIT "SoE error - data item less than minimum input value limit"

#define       EC_E_SOE_ERRORCODE_DATA_MAX_LIMIT ((EC_T_DWORD)EC_E_ERROR+0x99)
#define EC_SZTXT_E_SOE_ERRORCODE_DATA_MAX_LIMIT "SoE error - data item exceeds maximum input value limit"

#define       EC_E_SOE_ERRORCODE_DATA_INCOR     ((EC_T_DWORD)EC_E_ERROR+0x9a)
#define EC_SZTXT_E_SOE_ERRORCODE_DATA_INCOR     "SoE error - data item is incorrect" 

#define       EC_E_SOE_ERRORCODE_PASWD_PROT     ((EC_T_DWORD)EC_E_ERROR+0x9b)
#define EC_SZTXT_E_SOE_ERRORCODE_PASWD_PROT     "SoE error - data item is protected by password" 

#define       EC_E_SOE_ERRORCODE_TEMP_UNCHANGE  ((EC_T_DWORD)EC_E_ERROR+0x9c)
#define EC_SZTXT_E_SOE_ERRORCODE_TEMP_UNCHANGE  "SoE error - Data item temporary unchangeable (in AT or MDT)" 

#define       EC_E_SOE_ERRORCODE_INVL_INDIRECT  ((EC_T_DWORD)EC_E_ERROR+0x9d)
#define EC_SZTXT_E_SOE_ERRORCODE_INVL_INDIRECT  "SoE error - invalid indirect" 

#define       EC_E_SOE_ERRORCODE_TEMP_UNCHANGE1 ((EC_T_DWORD)EC_E_ERROR+0x9e)
#define EC_SZTXT_E_SOE_ERRORCODE_TEMP_UNCHANGE1 "SoE error - data item temporary unchangeable (parameter or opmode...)" 

#define       EC_E_SOE_ERRORCODE_ALREADY_ACTIVE ((EC_T_DWORD)EC_E_ERROR+0x9f)
#define EC_SZTXT_E_SOE_ERRORCODE_ALREADY_ACTIVE "SoE error - command already active" 

#define       EC_E_SOE_ERRORCODE_NOT_INTERRUPT  ((EC_T_DWORD)EC_E_ERROR+0x100)
#define EC_SZTXT_E_SOE_ERRORCODE_NOT_INTERRUPT  "SoE error - command not interruptable" 

#define       EC_E_SOE_ERRORCODE_CMD_NOT_AVAIL  ((EC_T_DWORD)EC_E_ERROR+0x101)
#define EC_SZTXT_E_SOE_ERRORCODE_CMD_NOT_AVAIL  "SoE error - command not available (in this phase)" 

#define       EC_E_SOE_ERRORCODE_CMD_NOT_AVAIL1 ((EC_T_DWORD)EC_E_ERROR+0x102)
#define EC_SZTXT_E_SOE_ERRORCODE_CMD_NOT_AVAIL1 "SoE error - command not available (invalid parameter...)" 

#define       EC_E_SOE_ERRORCODE_DRIVE_NO       ((EC_T_DWORD)EC_E_ERROR+0x103)
#define EC_SZTXT_E_SOE_ERRORCODE_DRIVE_NO       "SoE error - response drive number not identical with the requested drive number"

#define       EC_E_SOE_ERRORCODE_IDN            ((EC_T_DWORD)EC_E_ERROR+0x104)
#define EC_SZTXT_E_SOE_ERRORCODE_IDN            "SoE error - response IDN not identical with the requested IDN"

#define       EC_E_SOE_ERRORCODE_FRAGMENT_LOST  ((EC_T_DWORD)EC_E_ERROR+0x105)
#define EC_SZTEC_E_SOE_ERRORCODE_FRAGMENT_LOST  "SoE error - at least one fragment lost"

#define       EC_E_SOE_ERRORCODE_BUFFER_FULL    ((EC_T_DWORD)EC_E_ERROR+0x106)
#define EC_SZTEC_E_SOE_ERRORCODE_BUFFER_FULL    "SoE error - RX buffer is full (ecat call with to small data-buffer)"

#define       EC_E_SOE_ERRORCODE_NO_DATA        ((EC_T_DWORD)EC_E_ERROR+0x107)    
#define EC_SZTXT_E_SOE_ERRORCODE_NO_DATA        "SoE error - no data state."

#define       EC_E_SOE_ERRORCODE_NO_DEFAULT_VALUE  ((EC_T_DWORD)EC_E_ERROR+0x108)
#define EC_SZTXT_E_SOE_ERRORCODE_NO_DEFAULT_VALUE  "SoE error - no default value."

#define       EC_E_SOE_ERRORCODE_DEFAULT_LONG   ((EC_T_DWORD)EC_E_ERROR+0x109)    
#define EC_SZTXT_E_SOE_ERRORCODE_DEFAULT_LONG   "SoE error - default value transmission too long."

#define       EC_E_SOE_ERRORCODE_DEFAULT_WP     ((EC_T_DWORD)EC_E_ERROR+0x10a) 
#define EC_SZTXT_E_SOE_ERRORCODE_DEFAULT_WP     "SoE error - default value cannot be changed, read only." 

#define       EC_E_SOE_ERRORCODE_INVL_DRIVE_NO  ((EC_T_DWORD)EC_E_ERROR+0x10b)
#define EC_SZTXT_E_SOE_ERRORCODE_INVL_DRIVE_NO  "SoE error - invalid drive number." 

#define       EC_E_SOE_ERRORCODE_GENERAL_ERROR  ((EC_T_DWORD)EC_E_ERROR+0x10c)
#define EC_SZTXT_E_SOE_ERRORCODE_GENERAL_ERROR  "SoE error - general error"

#define       EC_E_SOE_ERRCODE_NO_ELEM_ADR      ((EC_T_DWORD)EC_E_ERROR+0x10d)
#define EC_SZTXT_E_SOE_ERRCODE_NO_ELEM_ADR      "SoE error - no element addressed." 

#define       EC_E_SLAVE_NOT_PRESENT            ((EC_T_DWORD)EC_E_ERROR+0x10e)
#define EC_SZTXT_E_SLAVE_NOT_PRESENT            "Command not executed. Slave is not present on Bus" 

#define       EC_E_NO_FOE_SUPPORT_BS            ((EC_T_DWORD)EC_E_ERROR+0x10f)
#define EC_SZTXT_E_NO_FOE_SUPPORT_BS            "ERROR: FoE protocol not supported in boot strap"

#define       EC_E_EEPROMRELOADERROR            ((EC_T_DWORD)EC_E_ERROR+0x110)
#define EC_SZTXT_E_EEPROMRELOADERROR            "ERROR: command error while EEPROM reload"

#define       EC_E_SLAVECTRLRESETERROR          ((EC_T_DWORD)EC_E_ERROR+0x111)
#define EC_SZTXT_E_SLAVECTRLRESETERROR          "ERROR: command error while Reset Slave Controller"

#define       EC_E_SYSDRIVERMISSING             ((EC_T_DWORD)EC_E_ERROR+0x112)
#define EC_SZTXT_E_SYSDRIVERMISSING             "ERROR: Cannot open system driver ect.sys"

#define       EC_E_BUSCONFIG_TOPOCHANGE         ((EC_T_DWORD)EC_E_ERROR+0x11E)
#define EC_SZTXT_E_BUSCONFIG_TOPOCHANGE         "Bus configuration not detected, Topology changed"

#define       EC_E_EOE_MBX_WKC_ERROR            ((EC_T_DWORD)EC_E_ERROR+0x11F)
#define EC_SZTXT_E_EOE_MBX_WKC_ERROR            "ERROR: EOE mailbox receive: working counter"
                                                
#define       EC_E_FOE_MBX_WKC_ERROR            ((EC_T_DWORD)EC_E_ERROR+0x120)
#define EC_SZTXT_E_FOE_MBX_WKC_ERROR            "ERROR: FOE mailbox receive: working counter"
                                                
#define       EC_E_SOE_MBX_WKC_ERROR            ((EC_T_DWORD)EC_E_ERROR+0x121)
#define EC_SZTXT_E_SOE_MBX_WKC_ERROR            "ERROR: SOE mailbox receive: working counter"
                                                
#define       EC_E_AOE_MBX_WKC_ERROR            ((EC_T_DWORD)EC_E_ERROR+0x122)
#define EC_SZTXT_E_AOE_MBX_WKC_ERROR            "ERROR: AOE mailbox receive: working counter"

#define       EC_E_VOE_MBX_WKC_ERROR            ((EC_T_DWORD)EC_E_ERROR+0x123)
#define EC_SZTXT_E_VOE_MBX_WKC_ERROR            "ERROR: VOE mailbox receive: working counter"

#define       EC_E_EEPROMASSIGNERROR            ((EC_T_DWORD)EC_E_ERROR+0x124)
#define EC_SZTXT_E_EEPROMASSIGNERROR            "ERROR: EEPROM assignment failed"

#define       EC_E_MBX_ERROR_TYPE               ((EC_T_DWORD)EC_E_ERROR+0x125)
#define EC_SZTXT_E_MBX_ERROR_TYPE               "ERROR: Error mailbox received"

#define       EC_E_REDLINEBREAK                 ((EC_T_DWORD)EC_E_ERROR+0x126)
#define EC_SZTXT_E_REDLINEBREAK                 "ERROR: Redundancy line break"

#define       EC_E_XML_INVALID_CMD_WITH_RED     ((EC_T_DWORD)EC_E_ERROR+0x127)
#define EC_SZTXT_E_XML_INVALID_CMD_WITH_RED     "ERROR: Invalid EtherCAT cmd in cyclic frame with redundancy"

#define       EC_E_XML_PREV_PORT_MISSING        ((EC_T_DWORD)EC_E_ERROR+0x128)
#define EC_SZTXT_E_XML_PREV_PORT_MISSING        "ERROR: <PreviousPort>-tag is missing!"

#define       EC_E_XML_DC_NOT_ALLOWED_WITH_RED  ((EC_T_DWORD)EC_E_ERROR+0x129)
#define EC_SZTXT_E_XML_DC_NOT_ALLOWED_WITH_RED  "ERROR: Distributed clocks not allowed in connection with redundancy!"

#define       EC_E_DLSTATUS_IRQ_TOPOCHANGED     ((EC_T_DWORD)EC_E_ERROR+0x130)
#define EC_SZTXT_E_DLSTATUS_IRQ_TOPOCHANGED     "ERROR: DL Status Interrupt because of changed Topology"

                
/*********************************************************************/
/* DCM Error Codes                                                   */
/*********************************************************************/

#define       DCM_E_NOTINITIALIZED              ((EC_T_DWORD)DCM_E_ERROR+0x01)  
#define DCM_SZTXT_E_NOTINITIALIZED              "ERROR: init function not called or not successful"

#define       DCM_E_MAX_CTL_ERROR_EXCEED        ((EC_T_DWORD)DCM_E_ERROR+0x02)  
#define DCM_SZTXT_E_MAX_CTL_ERROR_EXCEED        "ERROR: controller error - synchronisation out of limit"

#define       DCM_E_NOMEMORY                    ((EC_T_DWORD)DCM_E_ERROR+0x03)  
#define DCM_SZTXT_E_NOMEMORY                    "ERROR: not enough memory"

#define       DCM_E_INVALID_HWLAYER             ((EC_T_DWORD)DCM_E_ERROR+0x04)  
#define DCM_SZTXT_E_INVALID_HWLAYER             "ERROR: hardware layer - (BSP) invalid"

#define       DCM_E_TIMER_MODIFY_ERROR          ((EC_T_DWORD)DCM_E_ERROR+0x05)  
#define DCM_SZTXT_E_TIMER_MODIFY_ERROR          "ERROR: hardware layer - error modifying the timer"

#define       DCM_E_TIMER_NOT_RUNNING           ((EC_T_DWORD)DCM_E_ERROR+0x06)  
#define DCM_SZTXT_E_TIMER_NOT_RUNNING           "ERROR: hardware layer - timer is not running"

#define       DCM_E_WRONG_CPU                   ((EC_T_DWORD)DCM_E_ERROR+0x07)  
#define DCM_SZTXT_E_WRONG_CPU                   "ERROR: hardware layer - function is called on wrong CPU"

#define       DCM_E_INVALID_SYNC_PERIOD         ((EC_T_DWORD)DCM_E_ERROR+0x08)  
#define DCM_SZTXT_E_INVALID_SYNC_PERIOD         "ERROR: invalid DC sync period length (invalid clock master?)"

#define       DCM_E_INVALID_SETVAL              ((EC_T_DWORD)DCM_E_ERROR+0x09)  
#define DCM_SZTXT_E_INVALID_SETVAL              "ERROR: Error DCM Controller SetVal is to small."

#define       DCM_E_DRIFT_TO_HIGH              ((EC_T_DWORD)DCM_E_ERROR+0x0A)  
#define DCM_SZTXT_E_DRIFT_TO_HIGH               "ERROR: Error DCM Controller - Drift between local timer and ref clock to high."

/*********************************************************************/
/* RAS Error Codes                                                   */
/*********************************************************************/

#define EMRAS_SZTXT_EMRAS_E_ERROR               "RAS Error"

#define       EMRAS_E_INVALIDCOOKIE             ((EC_T_DWORD)EMRAS_E_ERROR+0x01)
#define EMRAS_SZTXT_E_INVALIDCOOKIE             "ERROR: Invalid cookie"

#define       EMRAS_E_MULSRVDISMULCON           ((EC_T_DWORD)EMRAS_E_ERROR+0x03)
#define EMRAS_SZTXT_E_MULSRVDISMULCON           "ERROR: Connecting 2nd server denied because Multi Server support is disabled"

#define       EMRAS_E_LOGONCANCELLED            ((EC_T_DWORD)EMRAS_E_ERROR+0x04)
#define EMRAS_SZTXT_E_LOGONCANCELLED            "ERROR: Logon cancelled"

#define       EMRAS_E_INVALIDVERSION            ((EC_T_DWORD)EMRAS_E_ERROR+0x06)
#define EMRAS_SZTXT_E_INVALIDVERSION            "ERROR: Invalid version"

#define       EMRAS_E_INVALIDACCESSCONFIG       ((EC_T_DWORD)EMRAS_E_ERROR+0x07)
#define EMRAS_SZTXT_E_INVALIDACCESSCONFIG       "ERROR: Access configuration is invalid"

#define       EMRAS_E_ACCESSLESS                ((EC_T_DWORD)EMRAS_E_ERROR+0x08)
#define EMRAS_SZTXT_E_ACCESSLESS                "ERROR: No access to this call at this accesslevel"

#define       EMRAS_EVT_SERVERSTOPPED           ((EC_T_DWORD)EMRAS_E_ERROR+0x11)
#define EMRAS_SZTXT_EVT_SERVERSTOPPED           "Server stopped"

#define       EMRAS_EVT_WDEXPIRED               ((EC_T_DWORD)EMRAS_E_ERROR+0x12)
#define EMRAS_SZTXT_EVT_WDEXPIRED               "Watchdog expired"

#define       EMRAS_EVT_RECONEXPIRED            ((EC_T_DWORD)EMRAS_E_ERROR+0x13)
#define EMRAS_SZTXT_EVT_RECONEXPIRED            "Reconnect expired"

#define       EMRAS_EVT_CLIENTLOGON             ((EC_T_DWORD)EMRAS_E_ERROR+0x14)
#define EMRAS_SZTXT_EVT_CLIENTLOGON             "Client logged on"

#define       EMRAS_EVT_RECONNECT               ((EC_T_DWORD)EMRAS_E_ERROR+0x15)            /* Client reconnect */
#define EMRAS_SZTXT_EVT_RECONNECT               "Client reconnect"

#define       EMRAS_EVT_SOCKCHANGE              ((EC_T_DWORD)EMRAS_E_ERROR+0x16)            /* Socket exchanged after Reconnect */
#define EMRAS_SZTXT_EVT_SOCKCHANGE              "Socket exchanged after reconnect"
                                   
#define       EMRAS_EVT_CLNTDISC                ((EC_T_DWORD)EMRAS_E_ERROR+0x17)            /* Socket exchanged after Reconnect */
#define EMRAS_SZTXT_EVT_CLNTDISC                "Client disconnect"


/*********************************************************************/
/* Application Framework Strings                                     */
/*********************************************************************/

#define       EC_TXT_MASTER_STATE_CHANGE        ((EC_T_WORD)(EC_TEXTBASE+0x0001))
#define EC_SZTXT_TXT_MASTER_STATE_CHANGE        "Master state change from <%s> to <%s>"

#define       EC_TXT_SB_RESULT_OK               ((EC_T_WORD)(EC_TEXTBASE+0x0002))
#define EC_SZTXT_TXT_SB_RESULT_OK               "Bus scan successful - %d slaves found"

#define       EC_TXT_SB_RESULT_ERROR            ((EC_T_WORD)(EC_TEXTBASE+0x0003))
#define EC_SZTXT_TXT_SB_RESULT_ERROR            "Bus scan error '%s (0x%x)', %d slaves found"

#define       EC_TXT_DC_STATUS                  ((EC_T_WORD)(EC_TEXTBASE+0x0004))
#define EC_SZTXT_TXT_DC_STATUS                  "Distributed clocks - status %s (0x%x)"

#define       EC_TXT_DCL_STATUS                 ((EC_T_WORD)(EC_TEXTBASE+0x0005))
#define EC_SZTXT_TXT_DCL_STATUS                 "Distributed clocks - latching status %s (0x%x)"

#define       EC_TXT_COE_SDO_DNLD_ERROR         ((EC_T_WORD)(EC_TEXTBASE+0x0006))
#define EC_SZTXT_TXT_COE_SDO_DNLD_ERROR         "CoE - SDO download failure, statVal=%d, errCode=0x%x (%s)"

#define       EC_TXT_COE_SDO_UPLD_ERROR         ((EC_T_WORD)(EC_TEXTBASE+0x0007))
#define EC_SZTXT_TXT_COE_SDO_UPLD_ERROR         "CoE - SDO upload failure, statVal=%d, errCode=0x%x (%s)"

#define       EC_TXT_COE_GETODL_ERROR           ((EC_T_WORD)(EC_TEXTBASE+0x0008))
#define EC_SZTXT_TXT_COE_GETODL_ERROR           "CoE - OD-list upload failure, statVal=%d, errCode=0x%x (%s)"

#define       EC_TXT_COE_GETOBDESC_ERROR        ((EC_T_WORD)(EC_TEXTBASE+0x0009))
#define EC_SZTXT_TXT_COE_GETOBDESC_ERROR        "CoE - object description upload failure, statVal=%d, errCode=0x%x (%s)"

#define       EC_TXT_COE_GETENTRYDESC_ERROR     ((EC_T_WORD)(EC_TEXTBASE+0x000A))
#define EC_SZTXT_TXT_COE_GETENTRYDESC_ERROR     "CoE - object entry description upload failure, statVal=%d, errCode=0x%x (%s)"

#define       EC_TXT_COE_EMRG_TFER_ERROR        ((EC_T_WORD)(EC_TEXTBASE+0x000B))
#define EC_SZTXT_TXT_COE_EMRG_TFER_ERROR        "CoE - emergency transfer failure, statVal=%d, errCode=0x%x (%s)"

#define       EC_TXT_COE_EMRG                   ((EC_T_WORD)(EC_TEXTBASE+0x000C))
#define EC_SZTXT_TXT_COE_EMRG                   "CoE - emergency request, id =0x%x, len=%d ==> slave address=%d, ErrCode=0x%x, ErrReg=0x%x, data: '%02x %02x %02x %02x %02x'."

#define       EC_TXT_CYCCMD_WKC_ERROR           ((EC_T_WORD)(EC_TEXTBASE+0x000D))
#define EC_SZTXT_TXT_CYCCMD_WKC_ERROR           "Cyclic command WKC error on %s - Address: 0x%x - WKC act/set=%d/%d"

#define       EC_TXT_MASTINITCMD_WKC_ERROR      ((EC_T_WORD)(EC_TEXTBASE+0x000E))
#define EC_SZTXT_TXT_MASTINITCMD_WKC_ERROR      "Master init command working counter error - Command: %s - Logical/Physical address: 0x%x, WKC act/set=%d/%d"

#define       EC_TXT_SLVINITCMD_WKC_ERROR       ((EC_T_WORD)(EC_TEXTBASE+0x000F))
#define EC_SZTXT_TXT_SLVINITCMD_WKC_ERROR       "Slave init command working counter error - Slave  \"%s\": - EtherCAT address=%d - Command: %s - Logical/Physical address: 0x%x, WKC act/set=%d/%d"

#define       EC_TXT_EOEMBXRCV_WKC_ERROR        ((EC_T_WORD)(EC_TEXTBASE+0x0010))
#define EC_SZTXT_TXT_EOEMBXRCV_WKC_ERROR        "EoE mbox receive working counter error - Slave  \"%s\": - EtherCAT address=%d - Command: %s - Logical/Physical address: 0x%x, WKC act/set=%d/%d"

#define       EC_TXT_COEMBXRCV_WKC_ERROR        ((EC_T_WORD)(EC_TEXTBASE+0x0011))
#define EC_SZTXT_TXT_COEMBXRCV_WKC_ERROR        "CoE mbox receive working counter error - Slave  \"%s\": - EtherCAT address=%d - Command: %s - Logical/Physical address: 0x%x, WKC act/set=%d/%d"

#define       EC_TXT_FOEMBXRCV_WKC_ERROR        ((EC_T_WORD)(EC_TEXTBASE+0x0012))
#define EC_SZTXT_TXT_FOEMBXRCV_WKC_ERROR        "FoE mbox receive working counter error - Slave  \"%s\": - EtherCAT address=%d - Command: %s - Logical/Physical address: 0x%x, WKC act/set=%d/%d"

#define       EC_TXT_SOEMBXRCV_WKC_ERROR        ((EC_T_WORD)(EC_TEXTBASE+0x0013))
#define EC_SZTXT_TXT_SOEMBXRCV_WKC_ERROR        "SoE mbox receive working counter error - Slave  \"%s\": - EtherCAT address=%d - Command: %s - Logical/Physical address: 0x%x, WKC act/set=%d/%d"

#define       EC_TXT_EOEMBXSND_WKC_ERROR        ((EC_T_WORD)(EC_TEXTBASE+0x0014))
#define EC_SZTXT_TXT_EOEMBXSND_WKC_ERROR        "EoE mbox send working counter error - Slave  \"%s\": - EtherCAT address=%d - Command: %s - Logical/Physical address: 0x%x, WKC act/set=%d/%d"

#define       EC_TXT_COEMBXSND_WKC_ERROR        ((EC_T_WORD)(EC_TEXTBASE+0x0015))
#define EC_SZTXT_TXT_COEMBXSND_WKC_ERROR        "CoE mbox send working counter error - Slave  \"%s\": - EtherCAT address=%d - Command: %s - Logical/Physical address: 0x%x, WKC act/set=%d/%d"

#define       EC_TXT_FOEMBXSND_WKC_ERROR        ((EC_T_WORD)(EC_TEXTBASE+0x0016))
#define EC_SZTXT_TXT_FOEMBXSND_WKC_ERROR        "FoE mbox send working counter error - Slave  \"%s\": - EtherCAT address=%d - Command: %s - Logical/Physical address: 0x%x, WKC act/set=%d/%d"

#define       EC_TXT_SOEMBXSND_WKC_ERROR        ((EC_T_WORD)(EC_TEXTBASE+0x0017))
#define EC_SZTXT_TXT_SOEMBXSND_WKC_ERROR        "SoE mbox send working counter error - Slave  \"%s\": - EtherCAT address=%d - Command: %s - Logical/Physical address: 0x%x, WKC act/set=%d/%d"

#define       EC_TXT_FRMRESP_RETRY              ((EC_T_WORD)(EC_TEXTBASE+0x0018))
#define EC_SZTXT_TXT_FRMRESP_RETRY              "Retry sending a %s frame due to %s"

#define       EC_TXT_FRMRESP_NORETRY            ((EC_T_WORD)(EC_TEXTBASE+0x0019))
#define EC_SZTXT_TXT_FRMRESP_NORETRY            "%s response on %s Ethernet frame"

#define       EC_TXT_ADDERRINFO                 ((EC_T_WORD)(EC_TEXTBASE+0x001A))
#define EC_SZTXT_TXT_ADDERRINFO                 "Additional error information: %s"

#define       EC_TXT_CMDIDXACTVAL               ((EC_T_WORD)(EC_TEXTBASE+0x001B))
#define EC_SZTXT_TXT_CMDIDXACTVAL               "EtherCAT command IDX act value=0x%x"

#define       EC_TXT_CMDIDXSETVAL               ((EC_T_WORD)(EC_TEXTBASE+0x001C))
#define EC_SZTXT_TXT_CMDIDXSETVAL               "EtherCAT command IDX set value=0x%x"

#define       EC_TXT_SLVINITCMDRSPERR_NR        ((EC_T_WORD)(EC_TEXTBASE+0x001D))
#define EC_SZTXT_TXT_SLVINITCMDRSPERR_NR        "Slave init command response error - Slave  \"%s\": - EtherCAT address=%d - Current State change of slave=\"%s\" No Response, is there a slave at this position?"

#define       EC_TXT_SLVINITCMDRSPERR_VE        ((EC_T_WORD)(EC_TEXTBASE+0x001E))
#define EC_SZTXT_TXT_SLVINITCMDRSPERR_VE        "Slave init command response error - Slave  \"%s\": - EtherCAT address=%d - Current State change of slave=\"%s\" Validation error, is the correct slave at this position?"

#define       EC_TXT_SLVINITCMDRSPERR_FLD       ((EC_T_WORD)(EC_TEXTBASE+0x001F))
#define EC_SZTXT_TXT_SLVINITCMDRSPERR_FLD       "Slave init command response error - Slave  \"%s\": - EtherCAT address=%d - Current State change of slave=\"%s\" target state could not be reached, is the correct slave at this position?"

#define       EC_TXT_MASTINITCMDRSPERR_NR       ((EC_T_WORD)(EC_TEXTBASE+0x0020))
#define EC_SZTXT_TXT_MASTINITCMDRSPERR_NR       "Master init command response error - Current State change of master=\"%s\" No Response, is there anything connected?"

#define       EC_TXT_MASTINITCMDRSPERR_VE       ((EC_T_WORD)(EC_TEXTBASE+0x0021))
#define EC_SZTXT_TXT_MASTINITCMDRSPERR_VE       "Master init command response error - Current State change of master=\"%s\" Validation error, are the correct slaves connected?"
                 
#define       EC_TXT_CMD_MISSING                ((EC_T_WORD)(EC_TEXTBASE+0x0022))
#define EC_SZTXT_TXT_CMD_MISSING                "Missing EtherCAT %s command in Ethernet frame - Slave  \"%s\": - EtherCAT address=%d - Index of missing command in the Ethernet frame=%d"

#define       EC_TXT_MBSLV_INITCMDTO            ((EC_T_WORD)(EC_TEXTBASE+0x0023))
#define EC_SZTXT_TXT_MBSLV_INITCMDTO            "\"Mailbox init command\" time-out - Slave  \"%s\": - EtherCAT address=%d - Current State change of slave=\"%s\""

#define       EC_TXT_NOT_ALL_DEVS_OP            ((EC_T_WORD)(EC_TEXTBASE+0x0024))
#define EC_SZTXT_TXT_NOT_ALL_DEVS_OP            "Not all EtherCAT slave devices are in operational state"

#define       EC_TXT_CABLE_CONNECTED            ((EC_T_WORD)(EC_TEXTBASE+0x0025))
#define EC_SZTXT_TXT_CABLE_CONNECTED            "Ethernet cable connected"

#define       EC_TXT_CABLE_NOT_CONNECTED        ((EC_T_WORD)(EC_TEXTBASE+0x0026))
#define EC_SZTXT_TXT_CABLE_NOT_CONNECTED        "Ethernet cable not connected"

#define       EC_TXT_CYCCMD_TIMEOUT             ((EC_T_WORD)(EC_TEXTBASE+0x0027))
#define EC_SZTXT_TXT_CYCCMD_TIMEOUT             "Cyclic command time-out: Time between sending cyclic commands too long"

#define       EC_TXT_REDLINEBREAK               ((EC_T_WORD)(EC_TEXTBASE+0x0028))
#define EC_SZTXT_TXT_REDLINEBREAK               "Redundancy Line break between slave %d and %d"

#define       EC_TXT_SLVERR_DETECTED            ((EC_T_WORD)(EC_TEXTBASE+0x0029))
#define EC_SZTXT_TXT_SLVERR_DETECTED            "At least one slave is in error status!"

#define       EC_TXT_SLVERR_INFO                ((EC_T_WORD)(EC_TEXTBASE+0x002A))
#define EC_SZTXT_TXT_SLVERR_INFO                "Slave error \"%s\": - EtherCAT address=%d - State <%s%s>(0x%x), control status <%s>(0x%x)"

#define       EC_TXT_SLV_NOT_ADDRABLE           ((EC_T_WORD)(EC_TEXTBASE+0x002B))
#define EC_SZTXT_TXT_SLV_NOT_ADDRABLE           "Unable to address slave \"%s\": - EtherCAT address=%d"

#define       EC_TXT_MBSLV_SDO_ABORT            ((EC_T_WORD)(EC_TEXTBASE+0x002C))
#define EC_SZTXT_TXT_MBSLV_SDO_ABORT            "SDO abort - Slave  \"%s\": - EtherCAT address=%d - %s (0x%x) - Index=0x%x SubIndex=0x%x"

#define       EC_TXT_DCSLVSYNC_INSYNC           ((EC_T_WORD)(EC_TEXTBASE+0x002D))
#define EC_SZTXT_TXT_DCSLVSYNC_INSYNC           "DC slaves are \"in-sync\" - Deviation: 0x%x"

#define       EC_TXT_DCSLVSYNC_OUTOFSYNC        ((EC_T_WORD)(EC_TEXTBASE+0x002E))
#define EC_SZTXT_TXT_DCSLVSYNC_OUTOFSYNC        "DC slaves are \"out-of-sync\" - Deviation: 0x%x"

#define       EC_TXT_DCL_SINGLE_LATCH           ((EC_T_WORD)(EC_TEXTBASE+0x002F))
#define EC_SZTXT_TXT_DCL_SINGLE_LATCH           "DC single latch on slave 0x%x Ident 0x%x"

#define       EC_TXT_FOE_UPLD_ERROR             ((EC_T_WORD)(EC_TEXTBASE+0x0030))
#define EC_SZTXT_TXT_FOE_UPLD_ERROR             "MbxTferRcv - file upload failure, statVal=%d, errCode=0x%x (%s)"

#define       EC_TXT_FOE_DNLD_ERROR             ((EC_T_WORD)(EC_TEXTBASE+0x0031))
#define EC_SZTXT_TXT_FOE_DNLD_ERROR             "MbxTferRcv - file download failure, statVal=%d, errCode=0x%x (%s)"

#define       EC_TXT_CLNTREGDROP                ((EC_T_WORD)(EC_TEXTBASE+0x0032))
#define EC_SZTXT_TXT_CLNTREGDROP                "Client registration lost!"

#define       EC_TXT_REDLINEFIXED               ((EC_T_WORD)(EC_TEXTBASE+0x0033))
#define EC_SZTXT_TXT_REDLINEFIXED               "Redundancy - Line is fixed"

#define       EC_TXT_SOEMBX_WRITE_ERROR         ((EC_T_WORD)(EC_TEXTBASE+0x0034))
#define EC_SZTXT_TXT_SOEMBX_WRITE_ERROR         "SoE init command mbox write error - Slave  \"%s\": - EtherCAT address=%d - Current State change of slave=\"%s\""

#define       EC_TXT_STATUSCODE_NOERROR          ((EC_T_WORD)(EC_ALSTATEBASE+0x0000))
#define EC_SZTXT_TXT_STATUSCODE_NOERROR          "No error"

#define       EC_TXT_STATUSCODE_ERROR           ((EC_T_WORD)(EC_ALSTATEBASE+0x0001))
#define EC_SZTXT_TXT_STATUSCODE_ERROR           "Unspecified error"
                                                
#define       EC_TXT_STATUSCODE_INVREQSTATECNG  ((EC_T_WORD)(EC_ALSTATEBASE+0x0011))
#define EC_SZTXT_TXT_STATUSCODE_INVREQSTATECNG  "Invalid requested state change"

#define       EC_TXT_STATUSCODE_UNKREQSTATE     ((EC_T_WORD)(EC_ALSTATEBASE+0x0012))
#define EC_SZTXT_TXT_STATUSCODE_UNKREQSTATE     "Unknown requested state"

#define       EC_TXT_STATUSCODE_BOOTSTRAPNSUPP  ((EC_T_WORD)(EC_ALSTATEBASE+0x0013))
#define EC_SZTXT_TXT_STATUSCODE_BOOTSTRAPNSUPP  "Bootstrap not supported"

#define       EC_TXT_STATUSCODE_NOVALIDFW       ((EC_T_WORD)(EC_ALSTATEBASE+0x0014))
#define EC_SZTXT_TXT_STATUSCODE_NOVALIDFW       "No valid firmware"

#define       EC_TXT_STATUSCODE_INVALIDMBXCNF1  ((EC_T_WORD)(EC_ALSTATEBASE+0x0015))
#define EC_SZTXT_TXT_STATUSCODE_INVALIDMBXCNF1  "Invalid mailbox configuration 1"

#define       EC_TXT_STATUSCODE_INVALIDMBXCNF2  ((EC_T_WORD)(EC_ALSTATEBASE+0x0016))
#define EC_SZTXT_TXT_STATUSCODE_INVALIDMBXCNF2  "Invalid mailbox configuration 2"

#define       EC_TXT_STATUSCODE_INVALIDSMCNF    ((EC_T_WORD)(EC_ALSTATEBASE+0x0017))
#define EC_SZTXT_TXT_STATUSCODE_INVALIDSMCNF    "Invalid sync manager configuration"

#define       EC_TXT_STATUSCODE_NOVALIDIN       ((EC_T_WORD)(EC_ALSTATEBASE+0x0018))
#define EC_SZTXT_TXT_STATUSCODE_NOVALIDIN       "No valid inputs available"

#define       EC_TXT_STATUSCODE_NOVALIDOUT      ((EC_T_WORD)(EC_ALSTATEBASE+0x0019))
#define EC_SZTXT_TXT_STATUSCODE_NOVALIDOUT      "No valid outputs available"

#define       EC_TXT_STATUSCODE_SYNCERROR       ((EC_T_WORD)(EC_ALSTATEBASE+0x001A))
#define EC_SZTXT_TXT_STATUSCODE_SYNCERROR       "Synchronization error"

#define       EC_TXT_STATUSCODE_SMWATCHDOG      ((EC_T_WORD)(EC_ALSTATEBASE+0x001B))
#define EC_SZTXT_TXT_STATUSCODE_SMWATCHDOG      "Sync manager watchdog"

#define       EC_TXT_STATUSCODE_INVSMTYPES      ((EC_T_WORD)(EC_ALSTATEBASE+0x001C))
#define EC_SZTXT_TXT_STATUSCODE_INVSMTYPES      "Invalid Sync Manager Types"

#define       EC_TXT_STATUSCODE_INVOUTCONFIG    ((EC_T_WORD)(EC_ALSTATEBASE+0x001D))
#define EC_SZTXT_TXT_STATUSCODE_INVOUTCONFIG    "Invalid Output Configuration"

#define       EC_TXT_STATUSCODE_INVINCONFIG     ((EC_T_WORD)(EC_ALSTATEBASE+0x001E))
#define EC_SZTXT_TXT_STATUSCODE_INVINCONFIG     "Invalid Input Configuration"

#define       EC_TXT_STATUSCODE_INVWDCONFIG     ((EC_T_WORD)(EC_ALSTATEBASE+0x001F))
#define EC_SZTXT_TXT_STATUSCODE_INVWDCONFIG     "Invalid Watchdog Configuration"

#define       EC_TXT_STATUSCODE_SLVNEEDCOLDRS   ((EC_T_WORD)(EC_ALSTATEBASE+0x0020))
#define EC_SZTXT_TXT_STATUSCODE_SLVNEEDCOLDRS   "Slave needs cold restart"

#define       EC_TXT_STATUSCODE_SLVNEEDINIT     ((EC_T_WORD)(EC_ALSTATEBASE+0x0021))
#define EC_SZTXT_TXT_STATUSCODE_SLVNEEDINIT     "Slave needs INIT"

#define       EC_TXT_STATUSCODE_SLVNEEDPREOP    ((EC_T_WORD)(EC_ALSTATEBASE+0x0022))
#define EC_SZTXT_TXT_STATUSCODE_SLVNEEDPREOP    "Slave needs PREOP"

#define       EC_TXT_STATUSCODE_SLVNEEDSAFEOP   ((EC_T_WORD)(EC_ALSTATEBASE+0x0023))
#define EC_SZTXT_TXT_STATUSCODE_SLVNEEDSAFEOP   "Slave needs SAFEOP"
                                                
#define       EC_TXT_STATUSCODE_INVOUTFMMUCNFG  ((EC_T_WORD)(EC_ALSTATEBASE+0x002D))
#define EC_SZTXT_TXT_STATUSCODE_INVOUTFMMUCNFG  "Invalid Output FMMU Configuration"

#define       EC_TXT_STATUSCODE_INVINFMMUCNFG   ((EC_T_WORD)(EC_ALSTATEBASE+0x002E))
#define EC_SZTXT_TXT_STATUSCODE_INVINFMMUCNFG   "Invalid Input FMMU Configuration"
                                                
#define       EC_TXT_STATUSCODE_INVDCSYNCCNFG   ((EC_T_WORD)(EC_ALSTATEBASE+0x0030))
#define EC_SZTXT_TXT_STATUSCODE_INVDCSYNCCNFG   "Invalid DC SYNCH Configuration"

#define       EC_TXT_STATUSCODE_INVDCLATCHCNFG  ((EC_T_WORD)(EC_ALSTATEBASE+0x0031))
#define EC_SZTXT_TXT_STATUSCODE_INVDCLATCHCNFG  "Invalid DC Latch Configuration"

#define       EC_TXT_STATUSCODE_PLLERROR        ((EC_T_WORD)(EC_ALSTATEBASE+0x0032))
#define EC_SZTXT_TXT_STATUSCODE_PLLERROR        "PLL Error"

#define       EC_TXT_STATUSCODE_INVDCIOERROR    ((EC_T_WORD)(EC_ALSTATEBASE+0x0033))
#define EC_SZTXT_TXT_STATUSCODE_INVDCIOERROR    "Invalid DC IO Error"

#define       EC_TXT_STATUSCODE_INVDCTOERROR    ((EC_T_WORD)(EC_ALSTATEBASE+0x0034))
#define EC_SZTXT_TXT_STATUSCODE_INVDCTOERROR    "Invalid DC Timeout Error"
                                                
#define       EC_TXT_STATUSCODE_MBX_EOE         ((EC_T_WORD)(EC_ALSTATEBASE+0x0042))
#define EC_SZTXT_TXT_STATUSCODE_MBX_EOE         "MBX_EOE"

#define       EC_TXT_STATUSCODE_MBX_COE         ((EC_T_WORD)(EC_ALSTATEBASE+0x0043))
#define EC_SZTXT_TXT_STATUSCODE_MBX_COE         "MBX_COE"

#define       EC_TXT_STATUSCODE_MBX_FOE         ((EC_T_WORD)(EC_ALSTATEBASE+0x0044))
#define EC_SZTXT_TXT_STATUSCODE_MBX_FOE         "MBX_FOE"

#define       EC_TXT_STATUSCODE_MBX_SOE         ((EC_T_WORD)(EC_ALSTATEBASE+0x0045))
#define EC_SZTXT_TXT_STATUSCODE_MBX_SOE         "MBX_SOE"
                                                
#define       EC_TXT_STATUSCODE_MBX_VOE         ((EC_T_WORD)(EC_ALSTATEBASE+0x004F))
#define EC_SZTXT_TXT_STATUSCODE_MBX_VOE         "MBX_VOE"

#define       EC_TXT_HC_DETAGRESULT_OK          ((EC_T_WORD)(EC_TEXTBASE+0x0050))
#define EC_SZTXT_TXT_HC_DETAGRESULT_OK          "Hot Connect detect all groups successful - %d groups found, %d groups are present, Mask: 0x%x"

#define       EC_TXT_HC_DETAGRESULT_ERROR       ((EC_T_WORD)(EC_TEXTBASE+0x0051))
#define EC_SZTXT_TXT_HC_DETAGRESULT_ERROR       "Hot Connect detect all groups error '%s (0x%x)', %d groups found"

#define       EC_TXT_HC_SLAVEPART               ((EC_T_WORD)(EC_TEXTBASE+0x0052))
#define EC_SZTXT_TXT_HC_SLAVEPART               "Slave %s with Fixed Addr 0x%x removed from Bus"

#define       EC_TXT_HC_SLAVEJOIN               ((EC_T_WORD)(EC_TEXTBASE+0x0053))
#define EC_SZTXT_TXT_HC_SLAVEJOIN               "Slave %s with Fixed Addr 0x%x added to Bus"

#define       EC_TXT_HC_TOPOCHGDONE             ((EC_T_WORD)(EC_TEXTBASE+0x0054))
#define EC_SZTXT_TXT_HC_TOPOCHGDONE             "Topology Change Performed %s (0x%x)"

#define       EC_TXT_HC_BORDERCLOSE             ((EC_T_WORD)(EC_TEXTBASE+0x0055))
#define EC_SZTXT_TXT_HC_BORDERCLOSE             "Border Close Performed on Port %x:%x (%s) with Result : %s (0x%x)"

#define       EC_TXT_SOE_WRITE_ERROR            ((EC_T_WORD)(EC_TEXTBASE+0x0056))
#define EC_SZTXT_TXT_SOE_WRITE_ERROR            "MbxTferRcv - Write IDN failure, statVal=%d, errCode=0x%x (%s)"

#define       EC_TXT_SOE_READ_ERROR             ((EC_T_WORD)(EC_TEXTBASE+0x0057))
#define EC_SZTXT_TXT_SOE_READ_ERROR             "MbxTferRcv - Read IDN failure, statVal=%d, errCode=0x%x (%s)"

#define       EC_TXT_SOE_EMRG_TFER_ERROR        ((EC_T_WORD)(EC_TEXTBASE+0x0058))
#define EC_SZTXT_TXT_SOE_EMRG_TFER_ERROR        "SoE - emergency transfer failure, statVal=%d, errCode=0x%x (%s)"

#define       EC_TXT_SOE_EMRG                   ((EC_T_WORD)(EC_TEXTBASE+0x0059))
#define EC_SZTXT_TXT_SOE_EMRG                   "SoE - emergency request, id =0x%x, len=%d ==> slave address=%d, ErrCode=0x%x, data: '%02x %02x %02x %02x %02x'."

#define       EC_TXT_SOE_NOTIFIC_TFER_ERROR     ((EC_T_WORD)(EC_TEXTBASE+0x005a))
#define EC_SZTXT_TXT_SOE_NOTIFIC_TFER_ERROR     "SoE - notification transfer failure, statVal=%d, errCode=0x%x (%s)"

#define       EC_TXT_SOE_NOTIFICATION           ((EC_T_WORD)(EC_TEXTBASE+0x005b))
#define EC_SZTXT_TXT_SOE_NOTIFICATION           "SoE - notification request, id =0x%x, len=%d ==> slave address=%d, Header=0x%x, IDN=%d, data: '%02x %02x %02x %02x %02x'."

#define       EC_TXT_MBSLV_FOE_ABORT            ((EC_T_WORD)(EC_TEXTBASE+0x005C))
#define EC_SZTXT_TXT_MBSLV_FOE_ABORT            "FoE abort - Slave  \"%s\": - EtherCAT address=%d - %s (0x%x)"

#define       EC_TXT_MBXRCV_INVALID_DATA        ((EC_T_WORD)(EC_TEXTBASE+0x005D))
#define EC_SZTXT_TXT_MBXRCV_INVALID_DATA        "Invalid mailbox data received - Slave  \"%s\": - EtherCAT address=%d"

#define       EC_TXT_PDIWATCHDOG                ((EC_T_WORD)(EC_TEXTBASE+0x005E))
#define EC_SZTXT_TXT_PDIWATCHDOG                "PDI Watchdog expired - Slave  \"%s\": - EtherCAT address=%d"



/*-MACROS--------------------------------------------------------------------*/

#endif /* INC_ECERROR */


/*-END OF SOURCE FILE--------------------------------------------------------*/
